using System;
using Server.Items;
using Server.Targeting;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	//[CorpseName( "a terathan warrior corpse" )]
	public class Drider : BaseCreature
	{
		private bool m_Matriarch = false;
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.MortalStrike;
					case 2: return WeaponAbility.CrushingBlow;
			}
		}
		
      [Constructable]
		public Drider() : this( 0.30 > Utility.RandomDouble() )
		{
		}
      
      [Constructable]
		public Drider( bool matriarch ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			m_Matriarch = matriarch;
         Name = "a drider";
			Body = ( m_Matriarch ) ? 72 : 70;
			BaseSoundID = ( m_Matriarch ) ? 599 : 589;
			Hue = Utility.RandomNeutralHue();

			SetStr( 505, 700 );
			SetDex( 202, 300 );
			SetInt( 502, 600 );

			SetHits( 1000, 1500 );
			SetStam( 305, 600 );
			
			if ( m_Matriarch )
			{
			   SetMana( 800, 1000 );
			   AI = AIType.AI_Mage;
         }

			SetDamage( 20, 30 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Poison, 60 );

			SetResistance( ResistanceType.Physical, 60, 80 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 80 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.MagicResist, 90.7, 140.0 );
			SetSkill( SkillName.Tactics, 97.6, 100.0 );
			SetSkill( SkillName.Wrestling, 97.6, 100.0 );
			SetSkill( SkillName.Anatomy, 97.6, 100.0 );
			SetSkill( SkillName.Magery, 80.0, 110.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Poisoning, 120.1, 140.0 );
			
			Fame = 6000;
			Karma = -9500;

			VirtualArmor = 80;
			Tamable = false;
			PackItem( new GreaterPoisonPotion() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			
			if ( m_Matriarch )
			   AddLoot( LootPack.HighScrolls, 4 );
		}

		public override int TreasureMapLevel{ get{ return 5; } }
		public override int Meat{ get{ return 4; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Deadly; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool Unprovokable{ get{ return true; } }
		
		public override bool OnBeforeDeath()
		{
         if ( m_Matriarch && 0.7 > Utility.RandomDouble() )
            SpillAcid( TimeSpan.FromSeconds( 10 ), 40, 50, 3, 5 );
			
         return base.OnBeforeDeath();
		}
		
		private DateTime m_NextAction = DateTime.Now;
		
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && DateTime.Now > m_NextAction )
			{
				Mobile target = this.Combatant;

				if ( 0.4 > Utility.RandomDouble() && !target.Paralyzed )
				{
				  target.FixedEffect( 0x37B9, 10, 5 );
				  target.SendSound( 516 );
// 				  defender.SendLocalizedMessage( 500111 ); // You are frozen and can not move.
				  target.Freeze( TimeSpan.FromSeconds( 4.0 ) );
            }
            else
            {
               if ( target.Poison == null )
               {
                  AOS.Damage( target, this, Utility.RandomMinMax( 20, 25 ), true, 0, 0, 0, 100, 0 );

                  target.FixedParticles( 0x36BD, 1, 10, 0x1F78, 0xA6, 0, (EffectLayer)255 );
                  target.ApplyPoison( this, Poison.Lethal );
               }
               else
               {
                  SpillAcid( TimeSpan.FromSeconds( 10 ), 10, 40, target );
               }
            }

				m_NextAction = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 25 ) );
			}
			base.OnActionCombat();
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			if ( 0.075 > Utility.RandomDouble() )
			{
				/* Rune Corruption
				 * Start cliloc: 1070846 "The creature magically corrupts your armor!"
				 * Effect: All resistances -70 (lowest 0) for 5 seconds
				 * End ASCII: "The corruption of your armor has worn off"
				 */

				ExpireTimer timer = (ExpireTimer)m_Table[defender];

				if ( timer != null )
				{
					timer.DoExpire();
					defender.SendLocalizedMessage( 1070845 ); // The creature continues to corrupt your armor!
				}
				else
					defender.SendLocalizedMessage( 1070846 ); // The creature magically corrupts your armor!

				List<ResistanceMod> mods = new List<ResistanceMod>();

				if ( defender.PhysicalResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Physical, (defender.PhysicalResistance > 70) ? -70 : -defender.PhysicalResistance ) );

				if ( defender.FireResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Fire, (defender.FireResistance > 70) ? -70 : -defender.FireResistance ) );

				if ( defender.ColdResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Cold, (defender.ColdResistance > 70) ? -70 : -defender.ColdResistance ) );

				if ( defender.PoisonResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Poison, (defender.PoisonResistance > 70) ? -70 : -defender.PoisonResistance ) );

				if ( defender.EnergyResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Energy, (defender.EnergyResistance > 70) ? -70 : -defender.EnergyResistance ) );

				for ( int i = 0; i < mods.Count; ++i )
					defender.AddResistanceMod( mods[i] );

				defender.FixedEffect( 0x37B9, 10, 5 );

				timer = new ExpireTimer( defender, mods, TimeSpan.FromSeconds( 3.0 ) );
				timer.Start();
				m_Table[defender] = timer;
			}
			
			base.OnGaveMeleeAttack( defender );
		}

		private static Hashtable m_Table = new Hashtable();

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;
			private List<ResistanceMod> m_Mods;

			public ExpireTimer( Mobile m, List<ResistanceMod> mods, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
				m_Mods = mods;
				Priority = TimerPriority.TwoFiftyMS;
			}

			public void DoExpire()
			{
				for ( int i = 0; i < m_Mods.Count; ++i )
					m_Mobile.RemoveResistanceMod( m_Mods[i] );

				Stop();
				m_Table.Remove( m_Mobile );
			}

			protected override void OnTick()
			{
				m_Mobile.SendMessage( "The corruption of your armor has worn off" );
				DoExpire();
			}
		}

		public Drider( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}